/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills;

import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.skill.IClickableSkill;
import dev.toma.gunsrpg.api.common.skill.ICooldown;
import dev.toma.gunsrpg.api.common.skill.IDescriptionProvider;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.skills.SimpleSkill;
import dev.toma.gunsrpg.common.skills.core.DescriptionContainer;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.util.IIntervalProvider;
import dev.toma.gunsrpg.util.Interval;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;

public class IronBuddySkill
extends SimpleSkill
implements ICooldown,
IClickableSkill,
IDescriptionProvider {
    private final DescriptionContainer container;
    private final float addedHealth;
    private final int totalCooldown;
    private int cooldown;

    public IronBuddySkill(SkillType<?> type, IIntervalProvider provider) {
        this(type, provider, 0.0f);
    }

    public IronBuddySkill(SkillType<?> type, IIntervalProvider provider, float extraHealth) {
        super(type);
        this.totalCooldown = provider.getTicks();
        this.addedHealth = extraHealth;
        this.container = new DescriptionContainer(type);
        this.container.addProperty("info", Math.round(100.0f + extraHealth));
        this.container.addProperty("cooldown", Interval.format(this.totalCooldown, initial -> initial.src(Interval.Unit.TICK).out(Interval.Unit.MINUTE)));
    }

    @Override
    public ITextComponent[] supplyDescription(int desiredLineCount) {
        return this.container.getLines();
    }

    @Override
    public int getMaxCooldown() {
        return this.totalCooldown;
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public void setOnCooldown() {
        this.cooldown = this.totalCooldown;
    }

    @Override
    public void onUse(PlayerEntity player) {
    }

    @Override
    public boolean canUse() {
        return this.cooldown <= 0;
    }

    @Override
    public void onSkillUsed(ServerPlayerEntity player) {
        this.setOnCooldown();
        IronGolemEntity ironGolem = new IronGolemEntity(EntityType.field_200757_aw, player.field_70170_p);
        Vector3d pos = player.func_213303_ch();
        ironGolem.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        ironGolem.func_70849_f(true);
        if (this.addedHealth > 0.0f) {
            ModifiableAttributeInstance attributeInstance = ironGolem.func_110148_a(Attributes.field_233818_a_);
            float newValue = (float)(attributeInstance.func_111125_b() + (double)this.addedHealth);
            attributeInstance.func_111128_a((double)newValue);
            ironGolem.func_70606_j(newValue);
        }
        player.field_70170_p.func_217376_c((Entity)ironGolem);
        PlayerData.get((PlayerEntity)player).ifPresent(data -> {
            IAttributeProvider provider = data.getAttributes();
            this.cooldown = (int)((double)this.cooldown * provider.getAttributeValue(Attribs.IRON_BUDDY_COOLDOWN));
            data.sync(2);
        });
    }

    @Override
    public void onUpdate(PlayerEntity player) {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    @Override
    public CompoundNBT saveData() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("cooldown", this.cooldown);
        return nbt;
    }

    @Override
    public void readData(CompoundNBT nbt) {
        this.cooldown = nbt.func_74762_e("cooldown");
    }
}

